<?php
/*
  $
*/

class worldnet_hpp
{
  var $code, $title, $description, $enabled;
  var $oid;

  function worldnet_hpp()
  {
    global $order;

    $this->code        = 'worldnet_hpp';
    $this->title       = MODULE_PAYMENT_WORLDNETHPP_TEXT_TITLE;
    $this->description = MODULE_PAYMENT_WORLDNETHPP_TEXT_DESCRIPTION;
    $this->sort_order  = MODULE_PAYMENT_WORLDNETHPP_SORT_ORDER;
    $this->enabled     = ((MODULE_PAYMENT_WORLDNETHPP_STATUS == 'True') ? true : false);

    if( (int)MODULE_PAYMENT_WORLDNETHPP_ORDER_STATUS_ID > 0 )
    {
      $this->order_status = MODULE_PAYMENT_WORLDNETHPP_ORDER_STATUS_ID;
    }

    if(is_object($order))
      $this->update_status();

    $this->form_action_url = (MODULE_PAYMENT_WORLDNETHPP_TEST_MODE == "Yes" ? "https://testpayments.worldnettps.com/merchant/paymentpage" : "https://payments.worldnettps.com/merchant/paymentpage");
  }

  // class methods
  function update_status()
  {
    global $order, $db;

    if( ($this->enabled == true) && ((int)MODULE_PAYMENT_WORLDNETHPP_ZONE > 0) )
    {
      $check_flag = false;
      $check = $db->Execute("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_WORLDNETHPP_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");
      while (!$check->EOF)
      {
        if ($check['zone_id'] < 1)
        {
          $check_flag = true;
          break;
        } 
        elseif ($check['zone_id'] == $order->billing['zone_id'])
        {
          $check_flag = true;
          break;
        }
		$check->MoveNext();
      }

      if($check_flag == false)
      {
        $this->enabled = false;
      }
    }
  }

  function javascript_validation()
  {
    return false;
  }

  function selection()
  {
    return array( 'id'     => $this->code,
                  'module' => $this->title );
  }

  function pre_confirmation_check()
  {
    return false;
  }

  function confirmation()
  {
    return false;
  }

  function process_button()
  {
    global $osC_Session, $db, $order, $currencies,$currency;

    // Calculate the next expected order id (adapted from code written by Eric Stamper - 01/30/2004 Released under GPL)
    $last_order_id = $db->Execute("select * from " . TABLE_ORDERS . " order by orders_id desc limit 1");
    $new_order_id = $last_order_id->fields['orders_id'];
    $new_order_id = ($new_order_id + 1);

    if ($currency == MODULE_PAYMENT_WORLDNETHPP_CURRENCY_2)
    {
        $my_currency = MODULE_PAYMENT_WORLDNETHPP_CURRENCY_2;
        $terminalid  = MODULE_PAYMENT_WORLDNETHPP_ID_2;
    	$secret      = MODULE_PAYMENT_WORLDNETHPP_SECRET_2;
    }
    else
    {
        $my_currency = MODULE_PAYMENT_WORLDNETHPP_CURRENCY;
        $terminalid  = MODULE_PAYMENT_WORLDNETHPP_ID;
    	$secret      = MODULE_PAYMENT_WORLDNETHPP_SECRET;
    }

	mt_srand((double)microtime()*1000000);
    
    $datetime = date('d-m-Y:H:i:s:000');
    $orderid = strftime("%H%M%S").mt_rand(100000, 999999);
	$email = $order->customer['email_address'];
    $curr = $my_currency;
	$receiptPageUrl = (($request_type == 'SSL') ? HTTPS_SERVER . DIR_WS_HTTPS_CATALOG : HTTP_SERVER . DIR_WS_CATALOG ) . 'before_process.php';

    $amount = number_format($order->info['total'] * $currencies->get_value($my_currency), $currencies->get_decimal_places($my_currency), '.', '');
	$hash = md5($terminalid . $orderid . $amount . $datetime . $receiptPageUrl . $secret);

    $process_button_string = zen_draw_hidden_field('TERMINALID',       $terminalid) .
                             zen_draw_hidden_field('osCsid',           session_id()) .
                             zen_draw_hidden_field('ORDERID',          $orderid) .
                             zen_draw_hidden_field('AMOUNT',           $amount) .
                             zen_draw_hidden_field('CURRENCY',         $curr) .
                             zen_draw_hidden_field('DATETIME',         $datetime) .
                             zen_draw_hidden_field('RECEIPTPAGEURL',   $receiptPageUrl).
                             zen_draw_hidden_field('HASH',             $hash).
                             (MODULE_PAYMENT_WORLDNETHPP_SEND_EMAIL == "Yes" ? zen_draw_hidden_field('EMAIL', $email) : "").
                             zen_draw_hidden_field('Expected ZenCart Order ID',$new_order_id) .
                             zen_draw_hidden_field('COMMENT',          urldecode($order->billing['firstname']) . ' ' . urldecode($order->billing['lastname']) . (strlen($order->billing['company'])>0?' ' . urldecode($order->billing['company']):'') ) .
                             zen_draw_hidden_field('PROD_ID',          STORE_NAME);

    return $process_button_string;
  }

  function before_process()
  {
    global $currency;

    $error = false;

    if ($currency == MODULE_PAYMENT_WORLDNETHPP_CURRENCY_2)
    {
        $terminalid = MODULE_PAYMENT_WORLDNETHPP_ID_2;
    }
    else
    {
        $terminalid = MODULE_PAYMENT_WORLDNETHPP_ID;
    }
    $secret       = MODULE_PAYMENT_WORLDNETHPP_SECRET;

    $orderid      = $_POST['ORDERID']      ;
    $amount       = $_POST['AMOUNT']       ;
    $datetime     = $_POST['DATETIME']     ;
    
    
    $result       = $_POST['RESULT']       ;
    
    $message      = $_POST['MESSAGE']      ;
    
    $authcode     = $_POST['AUTHCODE']     ;
    $pasref       = $_POST['PASREF']       ;
    $md5hash_post = $_POST['HASH']         ;
    $RESPONSECODE = $_POST['RESPONSECODE'] ;
	$RESPONSETEXT = $_POST['RESPONSETEXT'] ;

    $md5hash_new = md5($terminalid . $orderid . $amount . $datetime . $RESPONSECODE . $RESPONSETEXT . $secret);
    
    //Check to see if hashes match or not
    if ($md5hash_new != $md5hash_post)
    {
      $payment_error_return = 'payment_error=' . $this->code . '&error=' . TEXT_WORLDNETHPP_HASH_ERROR . " - Expected: " . $md5hash_new . " vs " . $md5hash_post;
      zen_redirect(zen_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
    }

    if($RESPONSECODE != "A")
    {
      $payment_error_return = 'payment_error=' . $this->code . '&error=' . TEXT_WORLDNETHPP_RESPONSE_ERROR . '. Bank Response: ' . $RESPONSETEXT;
      zen_redirect(zen_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
    }

    return false;
  }

  function after_process()
  {
    return false;
  }

  function get_error()
  {
    if (PHP_VERSION < 4.1)
    {
      global $_GET;
    }

    $error = array('title' => WORLDNETHPP_ERROR_TITLE,
                   'error' => ((isset($_GET['error'])) ? stripslashes(urldecode($_GET['error'])) : IPAYMENT_ERROR_MESSAGE));

    return $error;
  }

  function output_error()
  {
    return false;
  }

  function check()
  {
	global $db;
    if(!isset($this->_check))
    {
      $check_query = $db->Execute("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_WORLDNETHPP_STATUS'");
      $this->_check = $check_query->RecordCount();
    }
    return $this->_check;
  }

  function install()
  {
	global $db;
    $db->Execute(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES 
      (
        'Enable WorldNet TPS Module', 
        'MODULE_PAYMENT_WORLDNETHPP_STATUS', 
        'True', 
        'Do you want to accept WorldNet TPS payments?', 
        '6', 
        '1', 
        'zen_cfg_select_option(array(\'True\', \'False\'), ', now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'Test account?',
        'MODULE_PAYMENT_WORLDNETHPP_TEST_MODE',
        'Yes',
        'Is this a WorldNet Test account that you are using?',
        '6',
        '2',
        'zen_cfg_select_option(array(\'Yes\',\'No\'), ', now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'First Transaction Currency',
        'MODULE_PAYMENT_WORLDNETHPP_CURRENCY',
        'Selected Currency',
        'The first currency to use for credit card transactions',
        '6',
        '3',
        'zen_cfg_select_option(array(\'EUR\',\'GBP\',\'USD\'), ', now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES
      (
        'First Terminal ID',
        'MODULE_PAYMENT_WORLDNETHPP_ID',
        'TerminalID 1',
        'The Terminal ID provided by WorldNet TPS for the first currency',
        '6',
        '4',
        now())");

    $db->Execute(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES 
      (
        'First Shared Secret', 
        'MODULE_PAYMENT_WORLDNETHPP_SECRET', 
        '', 
        'The Shared Secret provided by WorldNet TPS for the first currency',
        '6', 
        '7',
        now())");

   $db->Execute(
     "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'Second Transaction Currency (if applicable)',
        'MODULE_PAYMENT_WORLDNETHPP_CURRENCY_2',
        'Selected Currency',
        'The second currency to use for credit card transactions',
        '6',
        '5',
        'zen_cfg_select_option(array(\'EUR\',\'GBP\',\'USD\'), ', now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES
      (
        'Second Terminal ID',
        'MODULE_PAYMENT_WORLDNETHPP_ID_2',
        'TerminalID 2',
        'The Terminal ID provided by WorldNet TPS for the second currency',
        '6',
        '6',
        now())");

    $db->Execute(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES 
      (
        'Second Shared Secret', 
        'MODULE_PAYMENT_WORLDNETHPP_SECRET_2', 
        '', 
        'The Shared Secret provided by WorldNet TPS for the second currency',
        '6', 
        '7',
        now())");

    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added)
      VALUES
      (
        'Send receipt from WorldNet TPS host?',
        'MODULE_PAYMENT_WORLDNETHPP_SEND_EMAIL',
        'No',
        'The WorldNet TPS host can send it\'s own non-configurable e-mail that only contains transaction information.',
        '6',
        '8',
        'zen_cfg_select_option(array(\'Yes\',\'No\'), ', now())");

    $db->Execute(
      "INSERT INTO " . 
      TABLE_CONFIGURATION . 
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
      VALUES 
      (
        'Sort order of display.', 
        'MODULE_PAYMENT_WORLDNETHPP_SORT_ORDER', 
        '0', 
        'Sort order of display. Lowest is displayed first.', 
        '6', 
        '9',
        now())");
  
    $db->Execute(
      "INSERT INTO " .
      TABLE_CONFIGURATION .
      " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added)
      VALUES
      (
        'Set Order Status',
        'MODULE_PAYMENT_WORLDNETHPP_ORDER_STATUS_ID',
        '0',
        'Set the status of orders made with this payment module to this value',
        '6',
        '10',
        'zen_cfg_pull_down_order_statuses(', 'zen_get_order_status_name', now())");
  }

  function remove()
  {
	global $db;
    $db->Execute("delete from " . TABLE_CONFIGURATION . " where configuration_key like 'MODULE_PAYMENT_WORLDNETHPP%';");
  }

  function keys()
  {
    return array(
      'MODULE_PAYMENT_WORLDNETHPP_STATUS'              ,
      'MODULE_PAYMENT_WORLDNETHPP_TEST_MODE'           ,
      'MODULE_PAYMENT_WORLDNETHPP_CURRENCY'            ,
      'MODULE_PAYMENT_WORLDNETHPP_ID'                  ,
      'MODULE_PAYMENT_WORLDNETHPP_SECRET'              ,
      'MODULE_PAYMENT_WORLDNETHPP_CURRENCY_2'          ,
      'MODULE_PAYMENT_WORLDNETHPP_ID_2'                ,
      'MODULE_PAYMENT_WORLDNETHPP_SECRET_2'            ,
      'MODULE_PAYMENT_WORLDNETHPP_SEND_EMAIL'          ,
      'MODULE_PAYMENT_WORLDNETHPP_ORDER_STATUS_ID'     ,
      'MODULE_PAYMENT_WORLDNETHPP_SORT_ORDER');
  }
}

?>
