<?php
/*
Plugin Name: Hikashop WorldNet Secure Payments (redirect)
Plugin URI: http://www.worldnettps.com/
Description: Extension for Hikashop with WorldNet TPS Hosted Payment Page redirect gateway.
Version: 1.0
Author: Namita Kapoor (WorldNet TPS)
Author URI: http://www.worldnettps.com/
License: GNU General Public License v3.0
License URI: http://www.gnu.org/licenses/gpl-3.0.html
*/

/*  Copyright 2016  WorldNEt TPS  (email: support@worldnettps.com)

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

class plgHikashoppaymentWorldnettpshpp extends hikashopPaymentPlugin
{
	
	var $accepted_currencies = array('EUR','GBP','USD','AUD','CAD','DKK','SEK','NOK');	
	var $multiple = true;	
	var $name = 'worldnettpshpp';	
	var $paymenturl='';
	var $pluginConfig = array(
                'gateway' => array('Gateway','list', array(
					'worldnet' => 'WorldNetTPS',
					'cashflows' => 'CashFlows',
					'payius' => 'Payius',
					'pagotechnology' => 'PagoTechnology',
					'globalone' => 'GlobalOnePay',
					'anywherecommerce' => 'AnywhereCommerce',
					'ctpayment' => 'CT-Payments',
					'payzone' => 'Payzone',
					'payconex' => 'PayConex')),
                'mode' => array('Test/Live Mode','list', array(
					'Test' => 'Test',
					'Live' => 'Live')),
		
		'terminalid' => array("Terminal ID",'input'),
		
		'secret_key' => array('Shared Secret', 'input'),
		
                'avs' => array('AVS','list', array(
					'1' => 'Enabled',
					'0' => 'Disabled')),
                'email' => array('Send Email Receipt','list',array(
					'1' => 'Enabled',
					'0' => 'Disabled')),

		'debug' => array('DEBUG', 'boolean','0'),
		//'invalid_status' => array('INVALID_STATUS', 'orderstatus'),
		//'verified_status' => array('VERIFIED_STATUS', 'orderstatus')
	);

		

	
	function __construct(&$subject, $config)
	{       
                
			
		return parent::__construct($subject, $config);
	}


	function onAfterOrderConfirm(&$order, &$methods, $method_id)
	{
		
		parent::onAfterOrderConfirm($order,$methods,$method_id);
		
		$this->paymenturl = 'https://'.($this->payment_params->mode=='Test'?'test':'');
 	
		switch($this->payment_params->gateway) {
			case "globalone" :
				$this->paymenturl .= 'payments.globalone.me';
				break;
			case "anywherecommerce" :
				$this->paymenturl .= 'payments.anywherecommerce.com';
				break;
			case "ctpayment" :
				$this->paymenturl .= 'payments.ct-payment.com';
				break;
			case "payconex" :
				$this->paymenturl .= 'gateway.payconex.net';
				break;
			case "payzone" :
				$this->paymenturl .= 'payment.payzone.ie';
				break;
			case "cashflows" :
				$this->paymenturl .= 'cashflows.worldnettps.com';
				break;
			case "pagotechnology" :
				$this->paymenturl .= 'payments.pagotechnology.com';
				break;
			case "payius" :
				$this->paymenturl .= 'payments.payius.com';
				break;
			case "worldnet" :
			default :
				$this->paymenturl .= 'payments.worldnettps.com';
		}       
			$this->paymenturl .= '/merchant/paymentpage';         
                   
                
                
		$return_url = HIKASHOP_LIVE.'index.php?option=com_hikashop&ctrl=checkout&task=after_end&order_id='.$order->order_id.$this->url_itemid;
                $notify_url = HIKASHOP_LIVE.'index.php?option=com_hikashop&ctrl=checkout&task=notify&notif_payment='.$this->name.'&tmpl=component&lang='.$this->locale . $this->url_itemid;
	        
		$amout = round($order->cart->full_total->prices[0]->price_value_with_tax, 2);
                $date = date('d-m-Y:H:i:s').':000';
                $currency = $this->currency->currency_code;

		
		if (empty($this->payment_params->terminalid))
		{
			
			$this->app->enqueueMessage('You have to configure an terminalid for the Example plugin payment first : check your plugin\'s parameters, on your website backend', 'error');
			return false;
		}
		elseif (empty($this->payment_params->secret_key))
		{
			$this->app->enqueueMessage('You have to configure a shared secret for the Example plugin payment first : check your plugin\'s parameters, on your website backend', 'error');
			return false;
		}
		elseif (empty($this->paymenturl))
		{
			 
                        $this->app->enqueueMessage('You have to configure a payment url for the Example plugin payment first : check your plugin\'s parameters, on your website backend', 'error');
			return false;
		}
		else
		{     				
			$hasharray = array(
				'TERMINALID' => $this->payment_params->terminalid,
			      	'ORDERID' => $order->order_id,
			      	'AMOUNT' => $amout,
                                'DATETIME' => $date,
				'RECEIPTPAGEURL' => $notify_url
                                   
			);
			$order_id = (int)@$hasharray['ORDERID'];
						
			if($this->payment_params->avs == 'Enabled')
				{
                                        $zip = @$order->cart->billing_address->address_post_code; 
					
                                }
                        
			$requesthash = $this->example_signature($this->payment_params->secret_key, $hasharray);
			$this->app->enqueueMessage($requesthash);
			$vars = array(
				'TERMINALID' => $this->payment_params->terminalid,
                                'ORDERID' => $order->order_id,
				'CURRENCY' => $currency,
                                'AMOUNT' => $amout,
                                'DATETIME' => $date,
                                'HASH' => $requesthash,
				'RECEIPTPAGEURL' => $notify_url 
                                
                                
					
                          );
                         if($this->payment_params->avs == '1')
				{      
                                   $vars["ADDRESS1"] = @$order->cart->billing_address->address_street;
                                   $vars["ADDRESS2"] = @$order->cart->billing_address->address_city . ", " . @$order->cart->billing_address->address_state->zone_code_3;
				   $vars["POSTCODE"] = @$order->cart->billing_address->address_post_code;  
				   
                                }
			if($this->payment_params->email == '1')
                             { 
				$vars["EMAIL"] = $this->user->user_email;
			     }
			$this->vars = $vars;
			
			return $this->showPage('end'); 
		}
	}

	function getPaymentDefaultValues(&$element)
	{
		$element->payment_name = 'WorldnetTPS HPP Payment';
		$element->payment_description = 'You can pay by credit card using this payment method';
		$element->payment_images = 'MasterCard,VISA,Credit_card,American_Express';
		$element->payment_params->address_type = 'billing';
		$element->payment_params->notification = 1;
		//$element->payment_params->invalid_status = 'cancelled';
		//$element->payment_params->verified_status = 'confirmed';
		$element->payment_params->payment_url = 'confirmed';
	}

	
	function onPaymentNotification(&$statuses)
	{
		$vars = array();
		$filter = JFilterInput::getInstance();
                $return_url = HIKASHOP_LIVE.'index.php?option=com_hikashop&ctrl=checkout&task=after_end';
               foreach($_REQUEST as $key => $value)
		{
			$key = $filter->clean($key);
			$value = JRequest::getString($key);
			$vars[$key] = $value;
                        
		}
                $order_id = (int)@$vars['ORDERID'];
		
		$dbOrder = $this->getOrder($order_id);
		$this->loadPaymentParams($dbOrder);
                 if(empty($this->payment_params))
			return false;
		$this->loadOrderData($dbOrder);
                		
                $hash = $this->example_signature($this->payment_params->secret_key, $vars, true, true);

                if($this->payment_params->debug)
		{
			// Here we display debug information which will be catched by HikaShop and stored in the payment log file available in the configuration's Files section.
			echo print_r($vars,true)."\n\n\n";
			echo print_r($dbOrder,true)."\n\n\n";
			echo print_r($hash,true)."\n\n\n";
		}

                
		if (strcasecmp($hash, $vars['HASH']) != 0)
		{
			
			if($this->payment_params->debug)
				echo 'Hash error '.$vars['HASH'].' - '.$hash."\n\n\n";
			return false;
		}
	        elseif ($vars['RESPONSECODE']!='A' || $vars['RESPONSETEXT']!='APPROVAL')
				{
                                        
					if($this->payment_params->debug)
						echo 'payment '.$vars['RESPONSETEXT']."\n\n\n";
					//$this->modifyOrder($order->order_id, $this->payment_params->invalid_status, true, true);
					$this->app->redirect($cancel_url);
					return false;
				}
				else
				{       
					echo "Success";					
					//$this->modifyOrder($order->order_id, $this->payment_params->verified_status, true, true);
					$this->app->redirect($return_url);
					return true;
				}
		   
		
		
		
	}

	
	function example_signature($secret, $parameters, $debug = false, $decode = false)
	{
		$clear_string = '';
		$expectedKey = array (
			'TERMINALID',
			'ORDERID',
			'AMOUNT',
			'DATETIME',
			'RECEIPTPAGEURL',
                        
		);

		if ($decode)
		{
			$clear_string = $parameters['TERMINALID'].$parameters['ORDERID'].$parameters['AMOUNT'].$parameters['DATETIME'].$parameters['RESPONSECODE'].$parameters['RESPONSETEXT'];
			
		}
		else
		{
			foreach ($parameters as $key => $value)
			{
				if (in_array($key,$expectedKey))
					$clear_string .= $value;
					
                                       
			}
		}
		$clear_string .= $secret;
		
		if (PHP_VERSION_ID < 50102) 
		{
			$this->app->enqueueMessage('The WorldNetTPS payment plugin requires at least the PHP 5.1.2 version to work, but it seems that it is not available on your server. Please contact your web hosting to set it up.','error');
			return false;
		}
		else
		{
			if($debug) echo 'Hash : '.$clear_string;
                         
			return hash('md5', $clear_string);
		}
	}
}
